<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAvailabilityJsonToAvailabilityTable extends Migration
{
    public function up()
    {
        Schema::table('availability', function (Blueprint $table) {
            $table->json('availability')->nullable();
            // Drop old columns if no longer needed
            $table->dropColumn('day_of_week');
            $table->dropColumn('time_slot');
            $table->dropColumn('status');
            $table->dropColumn('is_recurring');
        });
    }

    public function down()
    {
        Schema::table('availability', function (Blueprint $table) {
            $table->dropColumn('availability');
            // Restore old columns if needed
            $table->enum('day_of_week', ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'])->nullable();
            $table->enum('time_slot', ['Morning', 'Afternoon', 'Evening'])->nullable();
            $table->enum('status', ['available', 'no_data', 'booked'])->default('no_data');
            $table->boolean('is_recurring')->default(true);
        });
    }
}
